﻿using System;
using System.Web.UI;

namespace VIRP_WEB.Controls.Custom.EFR
{
    public partial class DateSelector : UserControl
    {
        DateTime? date;
        public DateTime? Date
        {
            get
            {
                date = DateTime.Parse(txtDate.Text);
                return date;
            }
            set
            {
                date = value;
                txtDate.Text = date.ToString();
            }
        }

        protected void Page_Load(object sender, EventArgs e)
        {
            txtDate.Text = Request.QueryString["strDate"];

            if (IsPostBack)
            {
                string st = @"<script type='text/javascript'>calendar(date);</script>";
                Page.ClientScript.RegisterStartupScript(GetType(), "CalendarScript", st, true);
            }
        }

        protected void ImageButtonCalendar_Click(object sender, ImageClickEventArgs e)
        {
            string st = @"<script type='text/javascript'>calendar(date);</script>";
            Page.ClientScript.RegisterStartupScript(GetType(), "CalendarScript", st, true);
        }
    }
}